﻿MyComponent = function() {
  MyComponent.initializeBase(this);
  this._address = null;
};

MyComponent.prototype = {
  get_address: function() {
    return this._address;
  },
  set_address: function(value) {
    if (this._address !== value) {
      this._address = value;
      this.raisePropertyChanged("address");
    }
  },
  
  add_initialized: function(handler) {  
    this.get_events().addHandler("initialized", handler);
  },
  remove_initialize: function(handler) {
    this.get_events().removeHandler("initialized", handler);
  },

  initialize: function() {
    MyComponent.callBaseMethod(this, 'initialize');

    var evt = this.get_events().getHandler("initialized");
    if (evt !== null) {
      evt(this, Sys.EventArgs.Empty);
    }
  }
};

MyComponent.registerClass("MyComponent", Sys.Component);

MyOtherComponent = function() {
  MyOtherComponent.initializeBase(this);

  this._subComponent = null;
};

MyOtherComponent.prototype = {
  _propertyChanged: function(sender, args) {
    if (args.get_propertyName() === "address") {
      alert ("Mój nowy adres: " + this._subComponent.get_address());
    }  
  },

  initialize: function() {
    MyOtherComponent.callBaseMethod(this, "initialize");
    
    this._subComponent = 
      $create(
        MyComponent,
        { 
          address: 
          "ul. Fałszywa 123" 
        },
        { 
          propertyChanged: 
          Function.createDelegate (
            this, 
            this._propertyChanged
          )
        },
        null,
        null);
        
    this._subComponent.set_address("ul. Kościuszki 40");  
  }
};

MyOtherComponent.registerClass("MyOtherComponent", Sys.Component);


Sys.Application.notifyScriptLoaded();


var myComponent = $create(
    MyOtherComponent,
    null,
    null,
    null,
    null);

